  '' FLASH IC test
  '' AT25SF041 FLASH IC on SPI bus
  OPTION EXPLICIT
  DIM BUCKET,FLASH_ID AS INTEGER                       'for dummy reads
  SPI OPEN 20000000, 0, 8                     'manually open SPI
  CONST FLASH_CS = 4
  SETPIN FLASH_CS, DOUT
  PIN(FLASH_CS)=1       ''CS HIGH
  'SETFLASHMODE(64)      ''sequential mode
  DIM A,I AS INTEGER
  
  FLASH_ID=READFLASHID()
  PRINT "FLASH CHIP ID:";HEX$(FLASH_ID)  
  PRINT "READ:"
  L1:
  IF (CHECKFLASHSTATUS() AND 1) = 1 THEN PRINT "NOT READY, WAITING 10ms":PAUSE 10:GOTO L1:
  STARTFLASHREAD(0)         'start at address 0
  FOR I = 0 to 30
    PRINT FLASHREAD();" ";
  NEXT I
  ENDFLASHREAD()
  PRINT
  PAUSE 1000
  PRINT "WRITE:"
  L2:
  IF (CHECKFLASHSTATUS() AND 1) = 1 THEN PRINT "NOT READY, WAITING 10ms":PAUSE 10:GOTO L2:
  SETFLASHWEL()
  FLASHERASEBLOCK4(0)     'blank first block
  L3:
  IF (CHECKFLASHSTATUS() AND 1) = 1 THEN PRINT "NOT READY, WAITING 10ms":PAUSE 10:GOTO L3:
  STARTFLASHWRITE(0)      'start write at 0
  FOR I = 0 to 30
    A= TIMER and 255
    FLASHWRITE(A)
    PRINT A;" ";
    PAUSE 1
  NEXT I
  ENDFLASHWRITE()
  PRINT
  PAUSE 1000
  
  PRINT "READ:"
  IF (CHECKFLASHSTATUS() AND 1) = 1 THEN PRINT "NOT READY, WAITING 10ms":PAUSE 10
  STARTFLASHREAD(0)         'start at address 0
  FOR I = 0 to 30
    PRINT FLASHREAD();" ";
  NEXT I
  ENDFLASHREAD()
  PRINT
  PAUSE 1000
END
  
FUNCTION READFLASHBYTE(A AS INTEGER)  ''read a single byte from A
  STARTFLASHREAD(A)
  READFLASHBYTE= FLASHREAD()
  ENDFLASHREAD()
END FUNCTION
  
SUB STARTFLASHREAD(A AS INTEGER)    ''start read transaction at address A
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(3)     ''read
  BUCKET = SPI((A\65536) AND 255)
  BUCKET = SPI((A\256) AND 255)
  BUCKET = SPI(A AND 255)
  'note CS is not raised- cannot do other things on SPI till read ends
END SUB
  
FUNCTION FLASHREAD()
  FLASHREAD=SPI(0)     ''dummy
END FUNCTION
  
SUB ENDFLASHREAD()
  PIN(FLASH_CS)=1       ''CS HIGH
END SUB
  
SUB STARTFLASHWRITE(A AS INTEGER)    ''start write transaction at address A
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(2)     ''write
  BUCKET = SPI((A\65536) AND 255)
  BUCKET = SPI((A\256) AND 255)
  BUCKET = SPI(A AND 255)
  'note CS is not raised- cannot do other things on SPI till read ends
END SUB
  
SUB FLASHWRITE(D AS INTEGER)      ''can write up to 256 bytes to buffer
  BUCKET=SPI(D)     ''dummy
END SUB
  
SUB ENDFLASHWRITE()
  PIN(FLASH_CS)=1       ''CS HIGH
END SUB
  
SUB SETFLASHWEL()		''set write enable latch, is cleared when write completes
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(6)     	''set WE latch
  PIN(FLASH_CS)=1       ''CS HIGH
END SUB
  
FUNCTION CHECKFLASHSTATUS()		'bit 0 is busy flag, bit 1 is WEL
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(5)     	''read Status Reg 1
  CHECKFLASHSTATUS = SPI(0) ''send dummy byte,get data
  PIN(FLASH_CS)=1       ''CS HIGH
END FUNCTION
  
FUNCTION READFLASHID()			'reads ID registers, should be &H1F8401 for AT25SF041
  PIN(FLASH_CS)=0       		''CS LOW
  BUCKET = SPI(&H9F)   			''read Man/Device ID
  READFLASHID=SPI(0)  			''send dummy, get byte 1
  READFLASHID=READFLASHID*256+SPI(0)  	''send dummy, get byte 2
  READFLASHID=READFLASHID*256+SPI(0)  	''send dummy, get byte 3
  PIN(FLASH_CS)=1       		''CS HIGH
END FUNCTION
  
SUB FLASHERASEBLOCK4(A AS INTEGER)    ''erase 4kB block that includes address A
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(32)     	''erase block
  BUCKET = SPI((A\65536) AND 255)
  BUCKET = SPI((A\256) AND 255)
  BUCKET = SPI(A AND 255)
  PIN(FLASH_CS)=1       ''CS HIGH
END SUB
  
SUB FLASHERASEBLOCK32(A AS INTEGER)    ''erase 32kB block that includes address A
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(82)     	''erase block
  BUCKET = SPI((A\65536) AND 255)
  BUCKET = SPI((A\256) AND 255)
  BUCKET = SPI(A AND 255)
  PIN(FLASH_CS)=1       ''CS HIGH
END SUB
  
SUB FLASHERASECHIP()		''erase entire chip
  PIN(FLASH_CS)=0       ''CS LOW
  BUCKET = SPI(96)     	''chip erase
  PIN(FLASH_CS)=1       ''CS HIGH
END SUB
